/*
 * Decompiled with CFR 0.152.
 */
package tech.feldman.betterrecords.block;

import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import tech.feldman.betterrecords.BetterRecords;
import tech.feldman.betterrecords.block.ItemModelProvider;
import tech.feldman.betterrecords.block.ModBlock;
import tech.feldman.betterrecords.block.ModBlockDirectional;
import tech.feldman.betterrecords.block.TESRProvider;
import tech.feldman.betterrecords.block.tile.TileFrequencyTuner;
import tech.feldman.betterrecords.client.render.RenderFrequencyTuner;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u00022\u00020\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J(\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0016J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u0017H\u0016JP\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020#H\u0016J \u0010&\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006'"}, d2={"Ltech/feldman/betterrecords/block/BlockFrequencyTuner;", "Ltech/feldman/betterrecords/block/ModBlockDirectional;", "Ltech/feldman/betterrecords/block/TESRProvider;", "Ltech/feldman/betterrecords/block/tile/TileFrequencyTuner;", "Ltech/feldman/betterrecords/block/ItemModelProvider;", "name", "", "(Ljava/lang/String;)V", "breakBlock", "", "world", "Lnet/minecraft/world/World;", "pos", "Lnet/minecraft/util/math/BlockPos;", "state", "Lnet/minecraft/block/state/IBlockState;", "dropItem", "getBoundingBox", "Lnet/minecraft/util/math/AxisAlignedBB;", "kotlin.jvm.PlatformType", "block", "Lnet/minecraft/world/IBlockAccess;", "getRenderClass", "Lkotlin/reflect/KClass;", "Ltech/feldman/betterrecords/client/render/RenderFrequencyTuner;", "getTileEntityClass", "onBlockActivated", "", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "hand", "Lnet/minecraft/util/EnumHand;", "side", "Lnet/minecraft/util/EnumFacing;", "hitX", "", "hitY", "hitZ", "onBlockAdded", "BetterRecords"})
public final class BlockFrequencyTuner
extends ModBlockDirectional
implements TESRProvider<TileFrequencyTuner>,
ItemModelProvider {
    @Override
    @NotNull
    public KClass<TileFrequencyTuner> getTileEntityClass() {
        return Reflection.getOrCreateKotlinClass(TileFrequencyTuner.class);
    }

    @Override
    @NotNull
    public KClass<RenderFrequencyTuner> getRenderClass() {
        return Reflection.getOrCreateKotlinClass(RenderFrequencyTuner.class);
    }

    public void func_176213_c(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState state) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        world.func_184138_a(pos, state, state, 3);
    }

    public AxisAlignedBB func_185496_a(@NotNull IBlockState state, @NotNull IBlockAccess block, @NotNull BlockPos pos) {
        AxisAlignedBB axisAlignedBB;
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        switch (this.func_176201_c(state)) {
            case 0: 
            case 2: {
                axisAlignedBB = new AxisAlignedBB(0.18, 0.0, 0.12, 0.82, 0.6, 0.88);
                break;
            }
            case 1: 
            case 3: {
                axisAlignedBB = new AxisAlignedBB(0.12, 0.0, 0.18, 0.88, 0.6, 0.82);
                break;
            }
            default: {
                axisAlignedBB = Block.field_185505_j;
            }
        }
        return axisAlignedBB;
    }

    public boolean func_180639_a(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState state, @NotNull EntityPlayer player, @NotNull EnumHand hand, @NotNull EnumFacing side, float hitX, float hitY, float hitZ) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)hand, (String)"hand");
        Intrinsics.checkParameterIsNotNull((Object)side, (String)"side");
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!(tileEntity instanceof TileFrequencyTuner)) {
            tileEntity = null;
        }
        TileFrequencyTuner tileFrequencyTuner = (TileFrequencyTuner)tileEntity;
        if (tileFrequencyTuner != null) {
            TileFrequencyTuner tileFrequencyTuner2;
            TileFrequencyTuner it = tileFrequencyTuner2 = tileFrequencyTuner;
            player.openGui((Object)BetterRecords.INSTANCE, 1, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        return false;
    }

    public void func_180663_b(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState state) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        this.dropItem(world, pos);
        super.func_180663_b(world, pos, state);
    }

    private final void dropItem(World world, BlockPos pos) {
        block3: {
            TileFrequencyTuner tileFrequencyTuner;
            TileFrequencyTuner te;
            TileEntity tileEntity = world.func_175625_s(pos);
            if (!(tileEntity instanceof TileFrequencyTuner)) {
                tileEntity = null;
            }
            TileFrequencyTuner tileFrequencyTuner2 = (TileFrequencyTuner)tileEntity;
            if (tileFrequencyTuner2 == null || (te = (tileFrequencyTuner = tileFrequencyTuner2)).getCrystal().func_190926_b()) break block3;
            Random random = new Random();
            double rx = random.nextDouble() * (double)0.8f + (double)0.1f;
            double ry = random.nextDouble() * (double)0.8f + (double)0.1f;
            double rz = random.nextDouble() * (double)0.8f + (double)0.1f;
            EntityItem entityItem = new EntityItem(world, (double)pos.func_177958_n() + rx, (double)pos.func_177956_o() + ry, (double)pos.func_177952_p() + rz, new ItemStack(te.getCrystal().func_77973_b(), te.getCrystal().func_190916_E(), te.getCrystal().func_77952_i()));
            if (te.getCrystal().func_77942_o()) {
                ItemStack itemStack = entityItem.func_92059_d();
                Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"entityItem.item");
                NBTTagCompound nBTTagCompound = te.getCrystal().func_77978_p();
                if (nBTTagCompound == null) {
                    Intrinsics.throwNpe();
                }
                itemStack.func_77982_d(nBTTagCompound.func_74737_b());
            }
            entityItem.field_70159_w = random.nextGaussian() * (double)0.05f;
            entityItem.field_70181_x = random.nextGaussian() * (double)0.05f + (double)0.2f;
            entityItem.field_70179_y = random.nextGaussian() * (double)0.05f;
            world.func_72838_d((Entity)entityItem);
            te.getCrystal().func_190920_e(0);
            ItemStack itemStack = ItemStack.field_190927_a;
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"ItemStack.EMPTY");
            te.setCrystal(itemStack);
        }
    }

    public BlockFrequencyTuner(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Material material = Material.field_151575_d;
        Intrinsics.checkExpressionValueIsNotNull((Object)material, (String)"Material.WOOD");
        super(material, name);
        this.func_149711_c(1.5f);
        this.func_149752_b(5.5f);
    }

    @Override
    public void bindTESR() {
        TESRProvider.DefaultImpls.bindTESR(this);
    }

    @Override
    public void registerTESRItemStacks(@NotNull ModBlock block) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)block), (String)"block");
        TESRProvider.DefaultImpls.registerTESRItemStacks(this, block);
    }

    @Override
    public void registerTileEntity(@NotNull Block block) {
        Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
        TESRProvider.DefaultImpls.registerTileEntity(this, block);
    }

    @Override
    public void registerItemModel(@NotNull ModBlock block) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)block), (String)"block");
        ItemModelProvider.DefaultImpls.registerItemModel(this, block);
    }
}

